/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_IdProm_2;
import fme._lib;
import fme.fmeFrame;

class CBRegisto_AutoFin
extends CBRegisto {
    Frame_IdProm_2 P01;
    int tab_index = 0;

    public String getPagina() {
        return CBData.getPagina("IdProm_2", "IdProm_2_N", CBData.ListaOutrosBenef, this.tab_index);
    }

    CBRegisto_AutoFin() {
        this.P01 = (Frame_IdProm_2)fmeFrame.Paginas.getPage("IdProm_2");
        if (this.P01 == null) {
            return;
        }
        this.initialize();
    }

    CBRegisto_AutoFin(Frame_IdProm_2 p2, int idx) {
        this.P01 = p2;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "AutoFin";
        this.started = true;
        this.Campos.add(new CHCampo_Text("cap_proprio", this.P01.getJTextField_AutoFin_CapitalProprio(), CFLib.VLD_VALOR_S0, this));
        this.Campos.add(new CHCampo_Text("act_liquido", this.P01.getJTextField_AutoFin_ActivoLiquido(), CFLib.VLD_VALOR_S0, this));
        this.Campos.add(new CHCampo_Text("autonomia", this.P01.getJTextField_AutoFin_Autonomia(), CFLib.VLD_VALOR_S0, this));
        this.Campos.add(new CHCampo_Text("passivo", this.P01.getJTextField_SitLiq_Passivo(), CFLib.VLD_VALOR_S0, this));
        this.Campos.add(new CHCampo_Text("activo", this.P01.getJTextField_SitLiq_Activo(), CFLib.VLD_VALOR_S0, this));
        this.Campos.add(new CHCampo_Text("cod_ies", this.P01.getJTextField_Financ_IES(), null, this));
        CBData.Params.bind_ano_cand_update(this);
    }

    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        if (!CBData.Params.getByName((String)"ano_cand").v.equals("")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            this.P01.bindAno("" + (ano - 1));
        } else {
            this.P01.bindAno("Ano ref -1");
        }
        this.P01.repaint();
        this.P01.revalidate();
    }

    public void on_update(String tag) {
        if (tag.equals("cap_proprio") || tag.equals("act_liquido")) {
            double cap_proprio = _lib.to_double(this.getByName((String)"cap_proprio").v);
            double act_liquido = _lib.to_double(this.getByName((String)"act_liquido").v);
            String res = "";
            if (act_liquido > 0.0) {
                res = "" + _lib.round_dec(cap_proprio / act_liquido, 4);
            }
            this.getByName("autonomia").setStringValue(res);
        }
    }

    void change_TipoBenef(boolean is_aopi) {
        if (this.P01.change_TipoBenef(is_aopi)) {
            if (is_aopi) {
                this.getByName("activo").setStringValue(this.getByName((String)"act_liquido").v);
                this.getByName("cap_proprio").setStringValue("");
                this.getByName("act_liquido").setStringValue("");
            } else {
                this.getByName("act_liquido").setStringValue(this.getByName((String)"activo").v);
                this.getByName("passivo").setStringValue("");
                this.getByName("activo").setStringValue("");
            }
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        String titulo;
        String string = titulo = this.P01.getJPanel_AutoFin().isVisible() ? "Autonomia Financeira" : "Situa\u00e7\u00e3o L\u00edquida";
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        this.extract();
        if (this.P01.getJPanel_AutoFin().isVisible()) {
            if (this.getByName("cap_proprio").isEmpty()) {
                err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "cap_proprio", "Capital Pr\u00f3prio - %o"));
            }
            if (this.getByName("act_liquido").isEmpty()) {
                err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "act_liquido", "Activo L\u00edquido - %o"));
            }
        }
        if (this.P01.getJPanel_SitLiq().isVisible()) {
            if (this.getByName("passivo").isEmpty()) {
                err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "passivo", "Passivo - %o"));
            }
            if (this.getByName("activo").isEmpty()) {
                err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "activo", "Activo - %o"));
            }
        }
        if (this.getByName("cod_ies").isEmpty()) {
            err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "cod_ies", "IES - %o"));
        }
        return err_list;
    }
}

